<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="#all"
	version="2.0">
	
	<xsl:output method="xml"/>
	<xsl:output indent="yes"/>
	<xsl:strip-space elements="*"/>
	
    <xsl:variable name="generateduidrootforthisrun">1.3.6.1.4.1.5962.1.1.0.0.0.1596151685.17196</xsl:variable>
	
	<xsl:variable name="patientiddelimiter">-</xsl:variable>
	<!--<xsl:variable name="patientidprefix">PDMR-</xsl:variable>-->
	<xsl:variable name="patientidprefix"></xsl:variable>
	<xsl:variable name="collectionprefix">PDMR-</xsl:variable>

	<xsl:variable name="nodeunitcodevalue"><xsl:text>{nodes}</xsl:text></xsl:variable>
	
	<xsl:template name="zeropadtotwodigits">
		<xsl:param name="nOrnn"/>
		<xsl:choose>
			<xsl:when test="string-length($nOrnn) = 1"><xsl:value-of select="concat('0',$nOrnn)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$nOrnn"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="convertmmddyytoyyyymmdd">
		<xsl:param name="mmddyy"/>
		<!--<xsl:message>mmddyy <xsl:value-of select="$mmddyy"/></xsl:message>-->
		<xsl:choose>
			<xsl:when test="string-length($mmddyy) &gt; 0">
				<xsl:variable name="mOrmm" select="substring-before($mmddyy,'/')"/>
				<xsl:variable name="mm"><xsl:call-template name="zeropadtotwodigits"><xsl:with-param name="nOrnn" select="$mOrmm"/></xsl:call-template></xsl:variable>
				<!--<xsl:message>mm <xsl:value-of select="$mm"/></xsl:message>-->
				<xsl:variable name="ddyy" select="substring-after($mmddyy,'/')"/>
				<!--<xsl:message>ddyy <xsl:value-of select="$ddyy"/></xsl:message>-->
				
				<xsl:variable name="dOrdd" select="substring-before($ddyy,'/')"/>
				<xsl:variable name="dd"><xsl:call-template name="zeropadtotwodigits"><xsl:with-param name="nOrnn" select="$dOrdd"/></xsl:call-template></xsl:variable>
				<!--<xsl:message>dd <xsl:value-of select="$dd"/></xsl:message>-->
				
				<xsl:variable name="yOryy" select="substring-after($ddyy,'/')"/>
				<xsl:variable name="yy"><xsl:call-template name="zeropadtotwodigits"><xsl:with-param name="nOrnn" select="$yOryy"/></xsl:call-template></xsl:variable>
				<!--<xsl:message>yy <xsl:value-of select="$yy"/></xsl:message>-->
				
			    <xsl:choose>
			        <xsl:when test="string-length($yy) = 2">
				        <xsl:value-of select="concat('20',$yy,$mm,$dd)"/>
			        </xsl:when>
			        <xsl:otherwise>
			            <xsl:value-of select="concat($yy,$mm,$dd)"/>
			        </xsl:otherwise>
			    </xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="/">
		
		<xsl:for-each select="mice/mouse">
			<xsl:message>animalid <xsl:value-of select="animalid"/></xsl:message>
			<xsl:if test="animalid != ''">
				<xsl:variable name="mousenumber">
					<xsl:choose>
						<xsl:when test="contains(animalid,'-')">
							<xsl:value-of select="replace(animalid,'.*-','')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="animalid"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:message>mousenumber <xsl:value-of select="$mousenumber"/></xsl:message>
				
				<xsl:variable name="patientid"><xsl:value-of select="$patientidprefix"/><xsl:value-of select="distributionlotname"/><xsl:value-of select="$patientiddelimiter"/><xsl:value-of select="$mousenumber"/></xsl:variable>
				<!--<xsl:variable name="patientid"><xsl:value-of select="replace(animalid,'.*-','')"/></xsl:variable>-->
				<xsl:message>patientid <xsl:value-of select="$patientid"/></xsl:message>
				
				<xsl:if test="$patientid != concat($patientidprefix,$patientiddelimiter)">
					<xsl:variable name="recordcount" select="position()"/>	<!-- need a numeric value for UID creation -->
					<xsl:message>recordcount <xsl:value-of select="$recordcount"/></xsl:message>
					
					<xsl:variable name="filename">individualxmlfiles/<xsl:value-of select="$recordcount"/>.xml</xsl:variable>
					<xsl:message>filename <xsl:value-of select="$filename"/></xsl:message>
					
					<xsl:variable name="implantdatemmddyy">
						<xsl:choose>
							<xsl:when test="string-length(btbimplant) &gt; 0"><xsl:value-of select="btbimplant"/></xsl:when>
							<xsl:when test="string-length(saipimplant) &gt; 0"><xsl:value-of select="saipimplant"/></xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:message>implantdatemmddyy <xsl:value-of select="$implantdatemmddyy"/></xsl:message>
					
					<xsl:variable name="implantdateyyyymmdd"><xsl:call-template name="convertmmddyytoyyyymmdd"><xsl:with-param name="mmddyy" select="$implantdatemmddyy"/></xsl:call-template></xsl:variable>
					<xsl:message>implantdateyyyymmdd <xsl:value-of select="$implantdateyyyymmdd"/></xsl:message>
					
					<xsl:variable name="excisedatemmddyy">
						<xsl:choose>
							<xsl:when test="string-length(btbtumorexcise) &gt; 0"><xsl:value-of select="btbtumorexcise"/></xsl:when>
							<xsl:when test="string-length(saiptumorexcise) &gt; 0"><xsl:value-of select="saiptumorexcise"/></xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:message>excisedatemmddyy <xsl:value-of select="$excisedatemmddyy"/></xsl:message>
					
					<xsl:variable name="excisedateyyyymmdd"><xsl:call-template name="convertmmddyytoyyyymmdd"><xsl:with-param name="mmddyy" select="$excisedatemmddyy"/></xsl:call-template></xsl:variable>
					<xsl:message>excisedateyyyymmdd <xsl:value-of select="$excisedateyyyymmdd"/></xsl:message>
					
					<xsl:variable name="dateofbirthyyyymmdd"><xsl:call-template name="convertmmddyytoyyyymmdd"><xsl:with-param name="mmddyy" select="dateofbirth"/></xsl:call-template></xsl:variable>
					<xsl:message>dateofbirthyyyymmdd <xsl:value-of select="$dateofbirthyyyymmdd"/></xsl:message>
					
					
					<xsl:choose>
						<!--<xsl:when test="not(doc-available($filename))">-->	<!-- does not work -->
						<xsl:when test="not(unparsed-text-available($filename))">
							<xsl:result-document method="xml" indent="yes" href="{$filename}">
								
								<DicomStructuredReport>
									<DicomStructuredReportHeader>
										
										<SOPClassUID element="0016" group="0008" vr="UI">
											<value number="1">1.2.840.10008.5.1.4.1.1.88.71</value>	<!-- Acquisition Context SR Storage -->
											<!--<value number="1">1.2.840.10008.5.1.4.1.1.88.22</value>-->	<!-- Enhanced SR Storage -->
										</SOPClassUID>
										
										<StudyInstanceUID element="000d" group="0020" vr="UI">
											<value number="1"><xsl:value-of select="$generateduidrootforthisrun"/>.<xsl:value-of select="$recordcount"/></value>	<!-- from dummy dcsmpte - REPLACE :( -->
										</StudyInstanceUID>
										
										<SeriesInstanceUID element="000e" group="0020" vr="UI">
											<value number="1"><xsl:value-of select="$generateduidrootforthisrun"/>.<xsl:value-of select="$recordcount"/></value>	<!-- from dummy dcsmpte - REPLACE :( -->
										</SeriesInstanceUID>
										
										<SOPInstanceUID element="0018" group="0008" vr="UI">
											<value number="1"><xsl:value-of select="$generateduidrootforthisrun"/>.<xsl:value-of select="$recordcount"/></value>	<!-- from dummy dcsmpte - REPLACE :( -->
										</SOPInstanceUID>
										
										<PatientName element="0010" group="0010" vr="PN">
											<value number="1"><xsl:value-of select="$patientid"/></value>
										</PatientName>
										<PatientID element="0020" group="0010" vr="LO">
											<value number="1"><xsl:value-of select="$patientid"/></value>
										</PatientID>
										<PatientBirthDate element="0030" group="0010" vr="DA">
											<value number="1"><xsl:value-of select="$dateofbirthyyyymmdd"/></value>
										</PatientBirthDate>
										<PatientSex element="0040" group="0010" vr="CS">
											<value number="1"><xsl:value-of select="patientgender"/></value>
										</PatientSex>
										
										<StrainDescription  element="0212" group="0010" vr="UC">
											<value number="1">NOD.Cg-Prkdc&lt;scid&gt; Il2rg&lt;tm1Wjl&gt;/SzJ</value>
										</StrainDescription>
										
										<StrainNomenclature  element="0213" group="0010" vr="LO">
											<value number="1">MGI_2013</value>
										</StrainNomenclature>
										
										<PatientSpeciesDescription  element="2201" group="0010" vr="LO">
											<value number="1">Mus musculus</value>
										</PatientSpeciesDescription>
										
										<!-- not used in SR -->
										<!--<AnatomicalOrientationType  element="2210" group="0010" vr="CS">
										 <value number="1">QUADRUPED</value>
										 </AnatomicalOrientationType>-->
										
										<PatientSpeciesCodeSequence  element="2202" group="0010" vr="SQ">
											<Item number="1">
												<CodeValue><value number="1">447612001</value></CodeValue>
												<CodeMeaning><value number="1">Mus musculus</value></CodeMeaning>
												<CodingSchemeDesignator><value number="1">SCT</value></CodingSchemeDesignator>
											</Item>
										</PatientSpeciesCodeSequence>
										
										<StrainCodeSequence  element="0219" group="0010" vr="SQ">
											<Item number="1">
												<CodeValue><value number="1">3577020</value></CodeValue>
												<CodeMeaning><value number="1">NOD.Cg-Prkdc&lt;scid&gt; Il2rg&lt;tm1Wjl&gt;/SzJ</value></CodeMeaning>
												<CodingSchemeDesignator><value number="1">MGI</value></CodingSchemeDesignator>
											</Item>
										</StrainCodeSequence>
										
										<PatientBreedDescription  element="2292" group="0010" vr="LO"/>
										
										<PatientBreedCodeSequence  element="2293" group="0010" vr="SQ"/>
										
										<BreedRegistrationSequence  element="2294" group="0010" vr="SQ"/>
										
										<ResponsiblePerson  element="2297" group="0010" vr="PN"/>
										
										<ResponsibleOrganization  element="2299" group="0010" vr="LO">
											<value number="1">Frederick National Laboratory for Cancer Research</value>
										</ResponsibleOrganization>
										
										<PatientSexNeutered  element="2203" group="0010" vr="CS">
											<value number="1">UNALTERED</value>
										</PatientSexNeutered>
										
										<ClinicalTrialProtocolID  element="0020" group="0012" vr="LO">
											<value number="1"><xsl:value-of select="$collectionprefix"/><xsl:value-of select="distributionlotname"/></value>
										</ClinicalTrialProtocolID>
										
										<ClinicalTrialProtocolName  element="0021" group="0012" vr="LO">
											<value number="1"><xsl:value-of select="ctepsdcdescription"/></value>
										</ClinicalTrialProtocolName>
										
										<ClinicalTrialSponsorName  element="0010" group="0012" vr="LO">
											<value number="1">National Cancer Institute</value>
										</ClinicalTrialSponsorName>
										
										<ClinicalTrialSiteID  element="0030" group="0012" vr="LO"/>
										
										<ClinicalTrialSiteName  element="0031" group="0012" vr="LO">
											<value number="1">Frederick National Laboratory for Cancer Research</value>
										</ClinicalTrialSiteName>
										
										<ClinicalTrialSubjectID  element="0040" group="0012" vr="LO">
											<value number="1"><xsl:value-of select="$patientid"/></value>
										</ClinicalTrialSubjectID>
										
										<StudyDate element="0020" group="0008" vr="DA">
											<value number="1"><xsl:value-of select="$implantdateyyyymmdd"/></value>
										</StudyDate>
										<StudyTime element="0030" group="0008" vr="TM">
											<value number="1">000000</value>
										</StudyTime>
										<ReferringPhysicianName element="0090" group="0008" vr="PN" />
										<StudyID element="0010" group="0020" vr="SH">
											<value number="1">MODELSR_<xsl:value-of select="$recordcount"/></value>
										</StudyID>
										<AccessionNumber element="0050" group="0008" vr="SH" />
										<StudyDescription element="1030" group="0008" vr="LO">
											<!--<value number="1"><xsl:value-of select="concat(distributionlotname,' (',ctepsdcdescription,')')"/></value>-->
											<value number="1">NCI PDMR Tumor Characterization</value>
										</StudyDescription>
										
										<Modality element="0060" group="0008" vr="CS">
											<value number="1">SR</value>
										</Modality>
										<SeriesNumber element="0011" group="0020" vr="IS">
											<value number="1">1</value>
										</SeriesNumber>
										<SeriesDate element="0021" group="0008" vr="DA">
											<value number="1"><xsl:value-of select="$implantdateyyyymmdd"/></value>
										</SeriesDate>
										<SeriesDescription element="103E" group="0008" vr="LO">
											<value number="1">PDM Mouse Overview</value>
										</SeriesDescription>
										<ReferencedPerformedProcedureStepSequence element="1111" group="0008" vr="SQ" />
										
										<Manufacturer element="0070" group="0008" vr="LO">
											<value number="1">PixelMed</value>
										</Manufacturer>
										<InstitutionName element="0080" group="0008" vr="LO"/>
										<StationName element="1010" group="0008" vr="SH">
											<value number="1">NONE</value>
										</StationName>
										<ManufacturerModelName element="1090" group="0008" vr="LO">
											<value number="1">XSLT</value>
										</ManufacturerModelName>
										<DeviceSerialNumber element="1000" group="0018" vr="LO">
											<value number="1">9273652935o1</value>
										</DeviceSerialNumber>
										<SoftwareVersions element="1020" group="0018" vr="LO">
											<value number="1">0.1</value>
										</SoftwareVersions>
										
										<InstanceNumber element="0013" group="0020" vr="IS">
											<value number="1">1</value>
										</InstanceNumber>
										<CompletionFlag element="a491" group="0040" vr="CS">
											<value number="1">COMPLETE</value>
										</CompletionFlag>
										<VerificationFlag element="a493" group="0040" vr="CS">
											<value number="1">UNVERIFIED</value>
										</VerificationFlag>
										
										<ContentDate group="0008" element="0023" vr="DA"><value number="1"><xsl:value-of select="$implantdateyyyymmdd"/></value></ContentDate>
										<ContentTime group="0008" element="0033" vr="TM"><value number="1">100000</value></ContentTime>		<!-- is Type 1 -->
										
										<PerformedProcedureCodeSequence element="a372" group="0040" vr="SQ" />
										
									</DicomStructuredReportHeader>
									<DicomStructuredReportContent>
										<container continuity="SEPARATE" sopclass="1.2.840.10008.5.1.4.1.1.88.71" template="8101" templatemappingresource="DCMR">
											
											<concept cm="Preclinical Small Animal Imaging Acquisition Context" csd="DCM" cv="127001" />
											
											<code relationship="HAS CONCEPT MOD">
												<concept cm="Language of Content Item and Descendants" csd="DCM" cv="121049" />
												<value cm="English" csd="RFC5646" cv="eng" />
												<code relationship="HAS CONCEPT MOD">
													<concept cm="Country of Language" csd="DCM" cv="121046" />
													<value cm="United States" csd="ISO3166_1" cv="US" />
												</code>
											</code>
											
											<pname relationship="HAS OBS CONTEXT"><concept cm="Person Observer Name" csd="DCM" cv="121008"/><value><xsl:text>SAIP^Imager</xsl:text></value></pname>
											
											<container continuity="SEPARATE" relationship="CONTAINS">
												<concept cm="Exogenous substance" csd="DCM" cv="127400"/>
												
												<code relationship="CONTAINS">
													<concept cm="Tumor Graft" csd="DCM" cv="127460"/>
													<xsl:choose>
														<xsl:when test="ctepsdcdescription = 'Adenocarcinoma - colon'">
															<value cm="Adenocarcinoma of large intestine" csd="SCT" cv="408645001"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Adencarcinoma - colon'">
															<value cm="Adenocarcinoma of large intestine" csd="SCT" cv="408645001"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Adenocarcinoma-Colon'">
															<value cm="Adenocarcinoma of large intestine" csd="SCT" cv="408645001"/>
														</xsl:when>
														
														
														<xsl:when test="ctepsdcdescription = 'Lung adenocarcinoma'">
															<value cm="Adenocarcinoma of lung" csd="SCT" cv="254626006"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Lung Cancer-Adencarcinoma'">
															<value cm="Adenocarcinoma of lung" csd="SCT" cv="254626006"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'JAX &#xd0; Lung Cancer'">
															<value cm="Lung cancer" csd="SCT" cv="93880001"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Adenocarcinoma - pancreas'">
															<value cm="Adenocarcinoma of pancreas" csd="SCT" cv="700423003"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Adenocarcinoma-Pancreas'">
															<value cm="Adenocarcinoma of pancreas" csd="SCT" cv="700423003"/>
														</xsl:when>
													    <xsl:when test="ctepsdcdescription = 'Adenocarcinoma-pancreas'">
													        <value cm="Adenocarcinoma of pancreas" csd="SCT" cv="700423003"/>
													    </xsl:when>
													    <xsl:when test="ctepsdcdescription = '10052747 Adenocarcinoma-pancreas'">
													        <value cm="Adenocarcinoma of pancreas" csd="SCT" cv="700423003"/>
													    </xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Melanoma'">
															<value cm="Melanoma" csd="SCT" cv="2092003"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Laryngeal squamous cell carcinoma'">
															<value cm="Squamous cell carcinoma of laryngeal cartilage" csd="SCT" cv="707357005"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Salivary Gland Cancer'">
															<value cm="Cancer of salivary gland" csd="SCT" cv="255072001"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Carcinosarcoma of the uterus'">
															<value cm="Carcinosarcoma of uterus" csd="SCT" cv="702369008"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Lung Cancer - Squamous Cell Carcinoma'">
															<value cm="Squamous cell carcinoma of lung" csd="SCT" cv="254634000"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Lung Cancer-Squamous Cell Carcinoma'">
															<value cm="Squamous cell carcinoma of lung" csd="SCT" cv="254634000"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'Squamous cell lung carcinoma'">
															<value cm="Squamous cell carcinoma of lung" csd="SCT" cv="254634000"/>
														</xsl:when>
														<xsl:when test="ctepsdcdescription = 'JAX - Lung Squamous Cell'">
															<value cm="Squamous cell carcinoma of lung" csd="SCT" cv="254634000"/>
														</xsl:when>
														
														<xsl:when test="matches(ctepsdcdescription,'Cervical cancer.*NOS')">	<!-- exact string = 'Cervical cancer, NOS' does not match -->
															<value cm="Cancer of cervix" csd="SCT" cv="363354003"/>
														</xsl:when>
														
														<xsl:when test="matches(ctepsdcdescription,'Renal cell carcinoma.*NOS')">	<!-- exact string = 'Renal cell carcinoma, NOS' does not match -->
															<value cm="Renal cell carcinoma" csd="SCT" cv="702391001"/>			<!-- use disorder not morphological abnormality -->
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Colon Cancer'">
															<value cm="Cancer of colon" csd="SCT" cv="363406005"/>
														</xsl:when>
													    
														<xsl:when test="ctepsdcdescription = 'Lip/oral cavity squam. cell car.'">
															<value cm="Squamous cell carcinoma of mouth" csd="SCT" cv="307502000"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Squamous cell carcinoma - skin'">
															<value cm="Squamous cell carcinoma of skin" csd="SCT" cv="254651007"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Squamous cell carcinoma - anus'">
															<value cm="Squamous cell carcinoma of anus" csd="SCT" cv="723265000"/>
														</xsl:when>
														
														<xsl:when test="matches(ctepsdcdescription,'H &amp; N squamous cell car.*NOS')">	<!-- exact string = 'H &amp; N squamous cell car., NOS' does not match -->
														    <value cm="Squamous cell carcinoma of head and neck" csd="SCT" cv="716659002"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Papillary thyroid carcinoma'">
															<value cm="Papillary thyroid carcinoma" csd="SCT" cv="255029007"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Non Small Cell Lung Cancer'">
															<value cm="Non-small cell lung cancer" csd="SCT" cv="254637007"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Merkel Cell Tumor'">
															<value cm="Merkel cell carcinoma" csd="SCT" cv="253001006"/>
														</xsl:when>
														
														<xsl:when test="ctepsdcdescription = 'Leiomyosarcoma - not uterine'">
															<value cm="Non-uterine leiomyosarcoma" csd="DCM" cv="130406"/>
														</xsl:when>
														
														<xsl:when test="matches(ctepsdcdescription,'Non-Rhabdo.*soft tissue sarcoma')">	<!-- exact string = 'Non-Rhabdo, soft tissue sarcoma' does not match -->
															<!--<value cm="Sarcoma of soft tissue" csd="SCT" cv="424952003"/>-->		<!-- Rhabdomyosarcoma is NOT a child of 424952003 -->
															<value cm="Soft tissue sarcoma, excluding rhabdomyosarcoma" csd="NCIt" cv="C148457"/>
														</xsl:when>
														
													    <xsl:when test="ctepsdcdescription = 'Ewing sarcoma/Peripheral PNET'">
													        <value cm="Ewing sarcoma / peripheral neuroectodermal tumor" csd="SCT" cv="703707001"/>	<!-- is only morph abn. not disorder, for the family -->
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Ewing Sarcoma'">
													        <value cm="Ewing's sarcoma" csd="SCT" cv="76909002"/>	<!-- is only morph abn. not disorder -->
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Neuroendocrine'">
													        <value cm="Neuroendocrine tumor" csd="SCT" cv="255046005"/>
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Transitional cell car. - uroth.'">
													        <value cm="Transitional cell carcinoma" csd="SCT" cv="27090000"/>	<!-- one of SNOMED CT synonyms is "Urothelial carcinoma", so presumably is specifically urothelial; would prefer concept for "disorder" rt. "morphological abnormality", but there isn't one -->
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Urothelial/Bladder Cancer'">
													            <value cm="Bladder cancer" csd="SCT" cv="399326009"/>
													    </xsl:when>
													    
													    <xsl:when test="matches(ctepsdcdescription,'Urothelial.bladder cancer.*NOS')">	<!-- exact string = 'Urothelial/bladder cancer, NOS' does not match -->
															<value cm="Bladder cancer" csd="SCT" cv="399326009"/>
														</xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Adenocarcinoma - rectum'">
													        <value cm="Adenocarcinoma of rectum" csd="SCT" cv="254582000"/>
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Ovarian Cancer'">
													        <value cm="Ovarian cancer" csd="SCT" cv="363443007"/>
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Mesotheliloma'">    <!-- note spelling mistake -->
													        <value cm="Malignant mesothelioma" csd="SCT" cv="62064005"/>
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Malignant Peripheral Nerve Sheath'">
													        <value cm="Malignant peripheral nerve sheath tumor" csd="SCT" cv="19897006"/>
													    </xsl:when>
													    
													    <xsl:when test="ctepsdcdescription = 'Fibrosarcoma'">
													        <value cm="Fibrosarcoma" csd="SCT" cv="53654007"/>
													    </xsl:when>

													    <xsl:when test="ctepsdcdescription = 'Alveolar Soft Part Sarcoma'">
													        <value cm="Alveolar soft part sarcoma" csd="SCT" cv="88195001"/>
													    </xsl:when>
													    
													    
														<xsl:otherwise>
														    <xsl:message>ERROR - Populating Tumor Graft - unrecognized ctepsdcdescription for tumor graft histologic type '<xsl:value-of select="ctepsdcdescription"/>' for Distribution Lot Name '<xsl:value-of select="distributionlotname"/>' Animal ID '<xsl:value-of select="animalid"/>'</xsl:message>
														</xsl:otherwise>
													</xsl:choose>
													
													<!-- children of Tumor Graft = Graft Histologic Type-->
													<xsl:if test="string-length($implantdateyyyymmdd) &gt; 0">
														<datetime relationship="HAS PROPERTIES"><concept cm="DateTime Started" csd="DCM" cv="111526"/><value><xsl:value-of select="$implantdateyyyymmdd"/></value></datetime>
													</xsl:if>
													
													<xsl:if test="string-length($excisedateyyyymmdd) &gt; 0">
														<datetime relationship="HAS PROPERTIES"><concept cm="DateTime Ended" csd="DCM" cv="111527"/><value><xsl:value-of select="$excisedateyyyymmdd"/></value></datetime>
													</xsl:if>
													
													<text relationship="HAS PROPERTIES"><concept cm="Brand Name" csd="DCM" cv="111529"/><value><xsl:value-of select="distributionlotname"/></value></text>
													
													<code relationship="HAS PROPERTIES">
														<concept cm="Route of administration" csd="SCT" cv="410675002"/>
														<value cm="Subcutaneous route" csd="SCT" cv="34206005"/>
														<code relationship="HAS PROPERTIES">
															<concept cm="Site of" csd="SCT" cv="272737002"/>
															<value cm="Flank" csd="SCT" cv="58602004"/>
															<code relationship="HAS CONCEPT MOD">
																<concept cm="Laterality" csd="SCT" cv="272741003"/>
																<value cm="Right" csd="SCT" cv="24028007"/>
															</code>
														</code>
													</code>
													
													<code relationship="HAS PROPERTIES">
														<concept cm="Tissue of origin" csd="DCM" cv="127401"/>
														<xsl:choose>
															<xsl:when test="ctepsdcdescription = 'Adenocarcinoma - colon'">
																<value cm="Colon" csd="SCT" cv="71854001"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Adencarcinoma - colon'">
																<value cm="Colon" csd="SCT" cv="71854001"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Adenocarcinoma-Colon'">
																<value cm="Colon" csd="SCT" cv="71854001"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Lung adenocarcinoma'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Lung Cancer-Adencarcinoma'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'JAX &#xd0; Lung Cancer'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Adenocarcinoma - pancreas'">
																<value cm="Pancreas" csd="SCT" cv="15776009"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Adenocarcinoma-Pancreas'">
																<value cm="Pancreas" csd="SCT" cv="15776009"/>
															</xsl:when>
														    <xsl:when test="ctepsdcdescription = 'Adenocarcinoma-pancreas'">
														        <value cm="Pancreas" csd="SCT" cv="15776009"/>
														    </xsl:when>
														    <xsl:when test="ctepsdcdescription = '10052747 Adenocarcinoma-pancreas'">
														        <value cm="Pancreas" csd="SCT" cv="15776009"/>
														    </xsl:when>
														    
															<xsl:when test="ctepsdcdescription = 'Melanoma'">
																<value cm="Skin" csd="SCT" cv="39937001"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Laryngeal squamous cell carcinoma'">
																<value cm="Larynx" csd="SCT" cv="4596009"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Salivary Gland Cancer'">
																<value cm="Salivary gland" csd="SCT" cv="385294005"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Carcinosarcoma of the uterus'">
																<value cm="Uterus" csd="SCT" cv="35039007"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Lung Cancer - Squamous Cell Carcinoma'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Lung Cancer-Squamous Cell Carcinoma'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'Squamous cell lung carcinoma'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															<xsl:when test="ctepsdcdescription = 'JAX - Lung Squamous Cell'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															
															<xsl:when test="matches(ctepsdcdescription,'Cervical cancer.*NOS')">	<!-- exact string = 'Cervical cancer, NOS' does not match -->
																<value cm="Cervix" csd="SCT" cv="71252005"/>
															</xsl:when>
															
															<xsl:when test="matches(ctepsdcdescription,'Renal cell carcinoma.*NOS')">	<!-- exact string = 'Renal cell carcinoma, NOS' does not match -->
																<value cm="Kidney" csd="SCT" cv="64033007"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Colon Cancer'">
																<value cm="Colon" csd="SCT" cv="71854001"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Lip/oral cavity squam. cell car.'">
																<value cm="Mouth" csd="SCT" cv="123851003"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Squamous cell carcinoma - skin'">
																<value cm="Skin" csd="SCT" cv="39937001"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Squamous cell carcinoma - anus'">
																<value cm="Anus" csd="SCT" cv="53505006"/>
															</xsl:when>
															
															<xsl:when test="matches(ctepsdcdescription,'H &amp; N squamous cell car.*NOS')">	<!-- exact string = 'H &amp; N squamous cell car., NOS' does not match -->
																<value cm="Head and neck" csd="SCT" cv="774007"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Papillary thyroid carcinoma'">
																<value cm="Thyroid" csd="SCT" cv="69748006"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Non Small Cell Lung Cancer'">
																<value cm="Lung" csd="SCT" cv="39607008"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Merkel Cell Tumor'">
																<value cm="Skin" csd="SCT" cv="39937001"/>
															</xsl:when>
															
															<xsl:when test="ctepsdcdescription = 'Leiomyosarcoma - not uterine'">
																<value cm="Connective tissue" csd="SCT" cv="21793004"/>
															</xsl:when>
															
															<xsl:when test="matches(ctepsdcdescription,'Non-Rhabdo.*soft tissue sarcoma')">	<!-- exact string = 'Non-Rhabdo, soft tissue sarcoma' does not match -->
																<value cm="Soft tissue" csd="SCT" cv="87784001"/>
															</xsl:when>
															
														    <xsl:when test="ctepsdcdescription = 'Ewing sarcoma/Peripheral PNET'">
														        <value cm="Bone and soft tissue" csd="DCM" cv="130407"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Ewing Sarcoma'">
														        <value cm="Bone and soft tissue" csd="DCM" cv="130407"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Neuroendocrine'">
														        <value cm="Soft tissue" csd="SCT" cv="87784001"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Transitional cell car. - uroth.'">
														        <value cm="Bladder" csd="SCT" cv="89837001"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Urothelial/Bladder Cancer'">
														        <value cm="Bladder" csd="SCT" cv="89837001"/>
														    </xsl:when>
														    
														    <xsl:when test="matches(ctepsdcdescription,'Urothelial.bladder cancer.*NOS')">	<!-- exact string = 'Urothelial/bladder cancer, NOS' does not match -->
																<value cm="Bladder" csd="SCT" cv="89837001"/>
															</xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Adenocarcinoma - rectum'">
														        <value cm="Rectum" csd="SCT" cv="34402009"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Ovarian Cancer'">
														        <value cm="Ovary" csd="SCT" cv="15497006"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Mesotheliloma'">    <!-- note spelling mistake -->
														        <value cm="Mesothelium" csd="SCT" cv="71400007"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Malignant Peripheral Nerve Sheath'">
														        <value cm="Peripheral nerve myelin sheath" csd="SCT" cv="61005006"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Fibrosarcoma'">
														        <value cm="Connective tissue" csd="SCT" cv="21793004"/>
														    </xsl:when>
														    
														    <xsl:when test="ctepsdcdescription = 'Alveolar Soft Part Sarcoma'">
														        <value cm="Connective tissue" csd="SCT" cv="21793004"/>
														    </xsl:when>
														    
														    
														    
															<xsl:otherwise>
															    <xsl:message>ERROR - Populating Tissue of origin - unrecognized ctepsdcdescription for tumor graft histologic type '<xsl:value-of select="ctepsdcdescription"/>' for Distribution Lot Name '<xsl:value-of select="distributionlotname"/>' Animal ID '<xsl:value-of select="animalid"/>'</xsl:message>
															</xsl:otherwise>
														</xsl:choose>
													</code>
													
													<code relationship="HAS PROPERTIES"><concept cm="Taxonomic rank of origin" csd="DCM" cv="127402"/><value cm="Homo sapiens" csd="SCT" cv="337915000"/></code>
												</code>
											</container>
										</container>
									</DicomStructuredReportContent>
								</DicomStructuredReport>
								
								
							</xsl:result-document>
							<xsl:choose>
								<!--<xsl:when test="doc-available($filename)">--> 	<!-- does not work -->
								<xsl:when test="unparsed-text-available($filename)">
									<xsl:message>Successfully wrote <xsl:value-of select="$filename"/></xsl:message>
								</xsl:when>
								<xsl:otherwise>
									<xsl:message>WARNING - Unsuccessfully wrote <xsl:value-of select="$filename"/></xsl:message>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:message>WARNING - Have already done <xsl:value-of select="$filename"/> - assume duplicate row and same values :(</xsl:message>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>

